/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.parameter;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.util.Strings;

public class FmtType
extends Parameter
implements Encodable {
    private static final long serialVersionUID = -8764966004966855480L;
    private final String type;
    private final String subtype;

    public FmtType(String aValue) {
        super("FMTTYPE");
        try {
            String[] components = Strings.unquote(aValue).split("/");
            this.type = components[0];
            this.subtype = components[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    @Override
    public final String getValue() {
        return this.type + "/" + this.subtype;
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<FmtType> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("FMTTYPE");
        }

        @Override
        public FmtType createParameter(String value) {
            return new FmtType(value);
        }
    }
}

