/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.parameter;

import java.net.URI;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.LinkRelationType;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;

public class LinkRel
extends Parameter {
    private static final String PARAM_NAME = "LINKREL";
    private final String value;

    public LinkRel(String value) {
        super(PARAM_NAME);
        this.value = value;
    }

    public LinkRel(LinkRelationType linkRelationType) {
        super(PARAM_NAME);
        this.value = linkRelationType.toString();
    }

    public LinkRel(URI uri) {
        super(PARAM_NAME);
        this.value = uri.toASCIIString();
    }

    public LinkRelationType getLinkRelationType() {
        return LinkRelationType.valueOf(this.value);
    }

    public URI getUri() {
        return URI.create(this.value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<LinkRel> {
        public Factory() {
            super(LinkRel.PARAM_NAME);
        }

        @Override
        public LinkRel createParameter(String value) {
            return new LinkRel(value);
        }
    }
}

