/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.parameter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.fortuna.ical4j.model.AddressList;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.util.Strings;

public class Member
extends Parameter {
    private static final long serialVersionUID = 287348849443687499L;
    private final List<URI> groups;

    public Member(String aValue) {
        super("MEMBER");
        try {
            this.groups = new AddressList(Strings.unquote(aValue)).getAddresses();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Member(List<URI> aList) {
        super("MEMBER");
        this.groups = aList;
    }

    public final List<URI> getGroups() {
        return new ArrayList<URI>(this.groups);
    }

    @Override
    public final String getValue() {
        return AddressList.toString(this.groups);
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<Member> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("MEMBER");
        }

        @Override
        public Member createParameter(String value) {
            return new Member(value);
        }
    }
}

