/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.parameter;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.Strings;

public class Range
extends Parameter
implements Encodable {
    private static final long serialVersionUID = -3057531444558393776L;
    private static final String VALUE_THISANDPRIOR = "THISANDPRIOR";
    private static final String VALUE_THISANDFUTURE = "THISANDFUTURE";
    public static final Range THISANDPRIOR = new Range("THISANDPRIOR");
    public static final Range THISANDFUTURE = new Range("THISANDFUTURE");
    private final String value;

    public Range(String aValue) {
        super("RANGE");
        this.value = Strings.unquote(aValue);
        if (!(CompatibilityHints.isHintEnabled("ical4j.compatibility.notes") || VALUE_THISANDPRIOR.equals(this.value) || VALUE_THISANDFUTURE.equals(this.value))) {
            throw new IllegalArgumentException("Invalid value [" + this.value + "]");
        }
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<Range> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("RANGE");
        }

        @Override
        public Range createParameter(String value) {
            switch (value.toUpperCase()) {
                case "THISANDFUTURE": {
                    return THISANDFUTURE;
                }
                case "THISANDPRIOR": {
                    return THISANDPRIOR;
                }
            }
            return new Range(value);
        }
    }
}

