/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.parameter;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.util.Strings;

public class Related
extends Parameter
implements Encodable {
    private static final long serialVersionUID = 1570525804115869565L;
    private static final String VALUE_START = "START";
    private static final String VALUE_END = "END";
    public static final Related START = new Related("START");
    public static final Related END = new Related("END");
    private final String value;

    public Related(String aValue) {
        super("RELATED");
        this.value = Strings.unquote(aValue);
        if (!VALUE_START.equals(this.value) && !VALUE_END.equals(this.value)) {
            throw new IllegalArgumentException("Invalid value [" + this.value + "]");
        }
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<Related> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("RELATED");
        }

        @Override
        public Related createParameter(String value) {
            switch (value.toUpperCase()) {
                case "END": {
                    return END;
                }
                case "START": {
                    return START;
                }
            }
            return new Related(value);
        }
    }
}

