/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.parameter;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.util.Strings;

public class Role
extends Parameter
implements Encodable {
    private static final long serialVersionUID = 1438225631470825963L;
    private static final String VALUE_CHAIR = "CHAIR";
    private static final String VALUE_REQ_PARTICIPANT = "REQ-PARTICIPANT";
    private static final String VALUE_OPT_PARTICIPANT = "OPT-PARTICIPANT";
    private static final String VALUE_NON_PARTICIPANT = "NON-PARTICIPANT";
    public static final Role CHAIR = new Role("CHAIR");
    public static final Role REQ_PARTICIPANT = new Role("REQ-PARTICIPANT");
    public static final Role OPT_PARTICIPANT = new Role("OPT-PARTICIPANT");
    public static final Role NON_PARTICIPANT = new Role("NON-PARTICIPANT");
    private final String value;

    public Role(String aValue) {
        super("ROLE");
        this.value = Strings.unquote(aValue);
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<Role> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("ROLE");
        }

        @Override
        public Role createParameter(String value) {
            switch (value.toUpperCase()) {
                case "CHAIR": {
                    return CHAIR;
                }
                case "NON-PARTICIPANT": {
                    return NON_PARTICIPANT;
                }
                case "OPT-PARTICIPANT": {
                    return OPT_PARTICIPANT;
                }
                case "REQ-PARTICIPANT": {
                    return REQ_PARTICIPANT;
                }
            }
            return new Role(value);
        }
    }
}

