/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.parameter;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.util.Strings;

public class ScheduleAgent
extends Parameter
implements Encodable {
    private static final long serialVersionUID = 4205758749959461020L;
    private static final String VALUE_SERVER = "SERVER";
    private static final String VALUE_CLIENT = "CLIENT";
    private static final String VALUE_NONE = "NONE";
    public static final ScheduleAgent SERVER = new ScheduleAgent("SERVER");
    public static final ScheduleAgent CLIENT = new ScheduleAgent("CLIENT");
    public static final ScheduleAgent NONE = new ScheduleAgent("NONE");
    private final String value;

    public ScheduleAgent(String aValue) {
        super("SCHEDULE-AGENT");
        this.value = Strings.unquote(aValue);
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<ScheduleAgent> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("SCHEDULE-AGENT");
        }

        @Override
        public ScheduleAgent createParameter(String value) {
            switch (value.toUpperCase()) {
                case "CLIENT": {
                    return CLIENT;
                }
                case "NONE": {
                    return NONE;
                }
                case "SERVER": {
                    return SERVER;
                }
            }
            return new ScheduleAgent(value);
        }
    }
}

