/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.parameter;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.Uris;

public class Schema
extends Parameter {
    private static final long serialVersionUID = -8581904779721020689L;
    public static final Schema SCHEMA_ACTION = new Schema(URI.create("https://schema.org/Action"));
    public static final Schema SCHEMA_PLACE = new Schema(URI.create("https://schema.org/Place"));
    public static final Schema SCHEMA_THING = new Schema(URI.create("https://schema.org/Thing"));
    public static final Schema SCHEMA_EVENT = new Schema(URI.create("https://schema.org/Event"));
    public static final Schema SCHEMA_PERSON = new Schema(URI.create("https://schema.org/Person"));
    private final URI uri;

    public Schema(String aValue) {
        super("SCHEMA");
        try {
            this.uri = Uris.create(Strings.unquote(aValue));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Schema(URI aUri) {
        super("SCHEMA");
        this.uri = aUri;
    }

    public final URI getUri() {
        return this.uri;
    }

    @Override
    public final String getValue() {
        return Uris.decode(Strings.valueOf(this.getUri()));
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<Schema> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("SCHEMA");
        }

        @Override
        public Schema createParameter(String value) {
            return new Schema(value);
        }
    }
}

