/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.parameter;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.Uris;

public class SentBy
extends Parameter
implements Encodable {
    private static final long serialVersionUID = -1169413145174029391L;
    private final URI address;

    public SentBy(String aValue) {
        super("SENT-BY");
        try {
            this.address = Uris.create(Strings.unquote(aValue));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public SentBy(URI aUri) {
        super("SENT-BY");
        this.address = aUri;
    }

    public final URI getAddress() {
        return this.address;
    }

    @Override
    public final String getValue() {
        return Uris.decode(Strings.valueOf(this.getAddress()));
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<SentBy> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("SENT-BY");
        }

        @Override
        public SentBy createParameter(String value) {
            return new SentBy(value);
        }
    }
}

