/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.parameter;

import java.time.ZoneId;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.util.Strings;

public class TzId
extends Parameter
implements Encodable {
    private static final long serialVersionUID = 2366516258055857879L;
    public static final String PREFIX = "/";
    private final String value;

    public TzId(String aValue) {
        super("TZID");
        this.value = Strings.unquote(aValue);
    }

    public ZoneId toZoneId() {
        return this.toZoneId(null);
    }

    public ZoneId toZoneId(TimeZoneRegistry timeZoneRegistry) {
        if (timeZoneRegistry != null && !timeZoneRegistry.getZoneRules().isEmpty()) {
            return timeZoneRegistry.getZoneId(this.getValue());
        }
        return TimeZoneRegistry.getGlobalZoneId(this.getValue());
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<TzId> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("TZID");
        }

        @Override
        public TzId createParameter(String value) {
            return new TzId(Strings.unescape(value));
        }
    }
}

