/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.parameter;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.util.Strings;

public class Value
extends Parameter
implements Encodable {
    private static final long serialVersionUID = -7238642734500301768L;
    private static final String VALUE_BINARY = "BINARY";
    private static final String VALUE_BOOLEAN = "BOOLEAN";
    private static final String VALUE_CAL_ADDRESS = "CAL-ADDRESS";
    private static final String VALUE_DATE = "DATE";
    private static final String VALUE_DATE_TIME = "DATE-TIME";
    private static final String VALUE_DURATION = "DURATION";
    private static final String VALUE_FLOAT = "FLOAT";
    private static final String VALUE_INTEGER = "INTEGER";
    private static final String VALUE_PERIOD = "PERIOD";
    private static final String VALUE_RECUR = "RECUR";
    private static final String VALUE_TEXT = "TEXT";
    private static final String VALUE_TIME = "TIME";
    private static final String VALUE_URI = "URI";
    private static final String VALUE_UTC_OFFSET = "UTC-OFFSET";
    public static final Value BINARY = new Value("BINARY");
    public static final Value BOOLEAN = new Value("BOOLEAN");
    public static final Value CAL_ADDRESS = new Value("CAL-ADDRESS");
    public static final Value DATE = new Value("DATE");
    public static final Value DATE_TIME = new Value("DATE-TIME");
    public static final Value DURATION = new Value("DURATION");
    public static final Value FLOAT = new Value("FLOAT");
    public static final Value INTEGER = new Value("INTEGER");
    public static final Value PERIOD = new Value("PERIOD");
    public static final Value RECUR = new Value("RECUR");
    public static final Value TEXT = new Value("TEXT");
    public static final Value TIME = new Value("TIME");
    public static final Value URI = new Value("URI");
    public static final Value UTC_OFFSET = new Value("UTC-OFFSET");
    public static final Value UID = new Value("UID");
    public static final Value XML_REFERENCE = new Value("XML-REFERENCE");
    private final String value;

    public Value(String aValue) {
        super("VALUE");
        this.value = Strings.unquote(aValue);
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    public static class Factory
    extends Content.Factory
    implements ParameterFactory<Value> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("VALUE");
        }

        @Override
        public Value createParameter(String value) {
            switch (value.toUpperCase()) {
                case "BINARY": {
                    return BINARY;
                }
                case "BOOLEAN": {
                    return BOOLEAN;
                }
                case "DATE": {
                    return DATE;
                }
                case "CAL-ADDRESS": {
                    return CAL_ADDRESS;
                }
                case "DATE-TIME": {
                    return DATE_TIME;
                }
                case "DURATION": {
                    return DURATION;
                }
                case "FLOAT": {
                    return FLOAT;
                }
                case "INTEGER": {
                    return INTEGER;
                }
                case "PERIOD": {
                    return PERIOD;
                }
                case "RECUR": {
                    return RECUR;
                }
                case "TEXT": {
                    return TEXT;
                }
                case "TIME": {
                    return TIME;
                }
                case "URI": {
                    return URI;
                }
                case "UTC-OFFSET": {
                    return UTC_OFFSET;
                }
            }
            return new Value(value);
        }
    }
}

