/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.property.immutable.ImmutableAction;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;

public class Action
extends Property {
    private static final long serialVersionUID = -2353353838411753712L;
    public static final String VALUE_AUDIO = "AUDIO";
    public static final String VALUE_DISPLAY = "DISPLAY";
    public static final String VALUE_EMAIL = "EMAIL";
    public static final String VALUE_PROCEDURE = "PROCEDURE";
    private String value;

    public Action() {
        super("ACTION");
    }

    public Action(String aValue) {
        super("ACTION");
        this.value = aValue;
    }

    public Action(ParameterList aList, String aValue) {
        super("ACTION", aList);
        this.value = aValue;
    }

    @Override
    public void setValue(String aValue) {
        this.value = aValue;
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return ValidationResult.EMPTY;
    }

    protected PropertyFactory<Action> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Action> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("ACTION");
        }

        @Override
        public Action createProperty(ParameterList parameters, String value) {
            if (parameters.getAll().isEmpty()) {
                switch (value.toUpperCase()) {
                    case "AUDIO": {
                        return ImmutableAction.AUDIO;
                    }
                    case "DISPLAY": {
                        return ImmutableAction.DISPLAY;
                    }
                    case "EMAIL": {
                        return ImmutableAction.EMAIL;
                    }
                    case "PROCEDURE": {
                        return ImmutableAction.PROCEDURE;
                    }
                }
            }
            return new Action(parameters, value);
        }

        @Override
        public Action createProperty() {
            return new Action();
        }
    }
}

