/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.parameter.Encoding;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.util.DecoderFactory;
import net.fortuna.ical4j.util.EncoderFactory;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.Uris;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.DescriptivePropertyValidators;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Attach
extends Property {
    private static final long serialVersionUID = 4439949507756383452L;
    private URI uri;
    private byte[] binary;

    public Attach() {
        super("ATTACH");
    }

    public Attach(ParameterList aList, String aValue) {
        super("ATTACH", aList);
        this.setValue(aValue);
    }

    public Attach(byte[] data) {
        this(new ParameterList(Arrays.asList(Encoding.BASE64, Value.BINARY)), data);
    }

    public Attach(ParameterList aList, byte[] data) {
        super("ATTACH", aList);
        this.binary = data;
        this.uri = null;
    }

    public Attach(URI aUri) {
        super("ATTACH");
        this.uri = aUri;
        this.binary = null;
    }

    public Attach(ParameterList aList, URI aUri) {
        super("ATTACH", aList);
        this.uri = aUri;
        this.binary = null;
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        if (Optional.of(Value.BINARY).equals(this.getParameter("VALUE"))) {
            return DescriptivePropertyValidators.ATTACH_BIN.validate(this);
        }
        return DescriptivePropertyValidators.ATTACH_URI.validate(this);
    }

    public final byte[] getBinary() {
        return this.binary;
    }

    public final URI getUri() {
        return this.uri;
    }

    @Override
    public final void setValue(String aValue) {
        Optional encoding = this.getParameter("ENCODING");
        if (encoding.isPresent()) {
            try {
                BinaryDecoder decoder = DecoderFactory.getInstance().createBinaryDecoder((Encoding)encoding.get());
                this.binary = decoder.decode(aValue.getBytes());
            }
            catch (UnsupportedEncodingException uee) {
                Logger log = LoggerFactory.getLogger(Attach.class);
                log.error("Error encoding binary data", (Throwable)uee);
            }
            catch (DecoderException de) {
                Logger log = LoggerFactory.getLogger(Attach.class);
                log.error("Error decoding binary data", (Throwable)de);
            }
        } else {
            try {
                this.uri = Uris.create(aValue);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    @Override
    public final String getValue() {
        if (this.getUri() != null) {
            return Uris.decode(Strings.valueOf(this.getUri()));
        }
        if (this.getBinary() != null) {
            try {
                Optional encoding = this.getParameter("ENCODING");
                BinaryEncoder encoder = EncoderFactory.getInstance().createBinaryEncoder((Encoding)encoding.get());
                return new String(encoder.encode(this.getBinary()));
            }
            catch (UnsupportedEncodingException | EncoderException uee) {
                Logger log = LoggerFactory.getLogger(Attach.class);
                log.error("Error encoding binary data", uee);
            }
        }
        return null;
    }

    public final void setBinary(byte[] binary) {
        this.binary = binary;
        this.uri = null;
    }

    public final void setUri(URI uri) {
        this.uri = uri;
        this.binary = null;
    }

    protected PropertyFactory<Attach> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Attach> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("ATTACH");
        }

        @Override
        public Attach createProperty(ParameterList parameters, String value) {
            return new Attach(parameters, value);
        }

        @Override
        public Attach createProperty() {
            return new Attach();
        }
    }
}

