/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.component.Participant;
import net.fortuna.ical4j.model.property.CalendarAddress;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.Uris;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.RelationshipPropertyValidators;

public class Attendee
extends Property {
    private static final long serialVersionUID = 8430929418723298803L;
    private URI calAddress;

    public Attendee() {
        super("ATTENDEE");
    }

    public Attendee(String aValue) {
        super("ATTENDEE");
        this.setValue(aValue);
    }

    public Attendee(ParameterList aList, String aValue) {
        super("ATTENDEE", aList);
        this.setValue(aValue);
    }

    public Attendee(URI aUri) {
        super("ATTENDEE");
        this.calAddress = aUri;
    }

    public Attendee(ParameterList aList, URI aUri) {
        super("ATTENDEE", aList);
        this.calAddress = aUri;
    }

    public Attendee(Participant participant) {
        super("ATTENDEE");
        CalendarAddress calAddressProp = (CalendarAddress)participant.getRequiredProperty("CALENDAR-ADDRESS");
        this.calAddress = calAddressProp.getCalAddress();
    }

    public Attendee(ParameterList parameters, Participant participant) {
        super("ATTENDEE", parameters);
        CalendarAddress calAddressProp = (CalendarAddress)participant.getRequiredProperty("CALENDAR-ADDRESS");
        this.calAddress = calAddressProp.getCalAddress();
    }

    @Override
    public final void setValue(String aValue) {
        try {
            this.calAddress = Uris.create(aValue);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return RelationshipPropertyValidators.ATTENDEE.validate(this);
    }

    public final URI getCalAddress() {
        return this.calAddress;
    }

    @Override
    public final String getValue() {
        return Uris.decode(Strings.valueOf(this.getCalAddress()));
    }

    public final void setCalAddress(URI calAddress) {
        this.calAddress = calAddress;
    }

    protected PropertyFactory<Attendee> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Attendee> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("ATTENDEE");
        }

        @Override
        public Attendee createProperty(ParameterList parameters, String value) {
            return new Attendee(parameters, value);
        }

        @Override
        public Attendee createProperty() {
            return new Attendee();
        }
    }
}

