/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.property.immutable.ImmutableBusyType;
import net.fortuna.ical4j.validate.PropertyValidator;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;

public class BusyType
extends Property {
    private static final long serialVersionUID = -5140360270562621159L;
    public static final String VALUE_BUSY = "BUSY";
    public static final String VALUE_BUSY_UNAVAILABLE = "BUSY-UNAVAILABLE";
    public static final String VALUE_BUSY_TENTATIVE = "BUSY-TENTATIVE";
    private String value;

    public BusyType() {
        super("BUSYTYPE");
    }

    public BusyType(String aValue) {
        super("BUSYTYPE");
        this.value = aValue;
    }

    public BusyType(ParameterList aList, String aValue) {
        super("BUSYTYPE", aList);
        this.value = aValue;
    }

    @Override
    public void setValue(String aValue) {
        this.value = aValue;
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return PropertyValidator.BUSY_TYPE.validate(this);
    }

    protected PropertyFactory<BusyType> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<BusyType> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("BUSYTYPE");
        }

        @Override
        public BusyType createProperty(ParameterList parameters, String value) {
            if (parameters.getAll().isEmpty()) {
                switch (value.toUpperCase()) {
                    case "BUSY": {
                        return ImmutableBusyType.BUSY;
                    }
                    case "BUSY-UNAVAILABLE": {
                        return ImmutableBusyType.BUSY_UNAVAILABLE;
                    }
                    case "BUSY-TENTATIVE": {
                        return ImmutableBusyType.BUSY_TENTATIVE;
                    }
                }
            }
            return new BusyType(parameters, value);
        }

        @Override
        public BusyType createProperty() {
            return new BusyType();
        }
    }
}

