/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.property.immutable.ImmutableCalScale;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.CalendarPropertyValidators;

public class CalScale
extends Property {
    private static final long serialVersionUID = 7446184786984981423L;
    public static final String VALUE_GREGORIAN = "GREGORIAN";
    private String value;

    public CalScale() {
        super("CALSCALE");
    }

    public CalScale(String aValue) {
        super("CALSCALE");
        this.value = aValue;
    }

    public CalScale(ParameterList aList, String aValue) {
        super("CALSCALE", aList);
        this.value = aValue;
    }

    @Override
    public void setValue(String aValue) {
        this.value = aValue;
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return CalendarPropertyValidators.CALSCALE.validate(this);
    }

    protected PropertyFactory<CalScale> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<CalScale> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("CALSCALE");
        }

        @Override
        public CalScale createProperty(ParameterList parameters, String value) {
            if (parameters.getAll().isEmpty() && CalScale.VALUE_GREGORIAN.equalsIgnoreCase(value)) {
                return ImmutableCalScale.GREGORIAN;
            }
            return new CalScale(parameters, value);
        }

        @Override
        public CalScale createProperty() {
            return new CalScale();
        }
    }
}

