/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.Uris;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;

public class CalendarAddress
extends Property {
    private static final long serialVersionUID = 8430929418723298803L;
    private URI calAddress;

    public CalendarAddress() {
        super("CALENDAR-ADDRESS");
    }

    public CalendarAddress(String aValue) {
        super("CALENDAR-ADDRESS");
        this.setValue(aValue);
    }

    public CalendarAddress(ParameterList aList, String aValue) {
        super("CALENDAR-ADDRESS", aList);
        this.setValue(aValue);
    }

    public CalendarAddress(URI aUri) {
        super("CALENDAR-ADDRESS");
        this.calAddress = aUri;
    }

    public CalendarAddress(ParameterList aList, URI aUri) {
        super("CALENDAR-ADDRESS", aList);
        this.calAddress = aUri;
    }

    @Override
    public final void setValue(String aValue) {
        try {
            this.calAddress = Uris.create(aValue);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return ValidationResult.EMPTY;
    }

    public final URI getCalAddress() {
        return this.calAddress;
    }

    @Override
    public final String getValue() {
        return Uris.decode(Strings.valueOf(this.getCalAddress()));
    }

    public final void setCalAddress(URI calAddress) {
        this.calAddress = calAddress;
    }

    protected PropertyFactory<CalendarAddress> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<CalendarAddress> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("CALENDAR-ADDRESS");
        }

        @Override
        public CalendarAddress createProperty(ParameterList parameters, String value) {
            return new CalendarAddress(parameters, value);
        }

        @Override
        public CalendarAddress createProperty() {
            return new CalendarAddress();
        }
    }
}

