/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.Uris;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;

public class Concept
extends Property {
    private static final String PROPERTY_NAME = "CONCEPT";
    private URI uri;

    public Concept() {
        super(PROPERTY_NAME);
    }

    public Concept(URI uri) {
        super(PROPERTY_NAME);
        this.uri = uri;
    }

    public Concept(ParameterList aList, String value) {
        super(PROPERTY_NAME, aList);
        this.setValue(value);
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public String getValue() {
        return Uris.decode(Strings.valueOf(this.getUri()));
    }

    @Override
    public void setValue(String aValue) {
        try {
            this.uri = Uris.create(aValue);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return null;
    }

    @Override
    protected PropertyFactory<?> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Concept> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super(Concept.PROPERTY_NAME);
        }

        @Override
        public Concept createProperty(ParameterList parameters, String value) {
            return new Concept(parameters, value);
        }

        @Override
        public Concept createProperty() {
            return new Concept();
        }
    }
}

