/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TemporalAdapter;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.parameter.Value;

public abstract class DateListProperty<T extends Temporal>
extends Property {
    private static final long serialVersionUID = 5233773091972759919L;
    private final Value defaultValueParam;
    private DateList<T> dates;
    private transient TimeZoneRegistry timeZoneRegistry;
    private ZoneId defaultTimeZone;

    public DateListProperty(String name) {
        this(name, new DateList());
    }

    public DateListProperty(String name, ParameterList parameters, Value defaultValueParam) {
        super(name, parameters);
        this.defaultValueParam = defaultValueParam;
    }

    public DateListProperty(String name, DateList<T> dates) {
        this(name, new ParameterList(), dates, Value.DATE_TIME);
    }

    public DateListProperty(String name, ParameterList parameters, DateList<T> dates, Value defaultValueParam) {
        super(name, parameters);
        this.dates = dates;
        this.defaultValueParam = defaultValueParam;
    }

    public final List<T> getDates() {
        Optional tzId = this.getParameter("TZID");
        if (tzId.isPresent()) {
            return this.dates.getDates().stream().map(date -> TemporalAdapter.toLocalTime(date, ((TzId)tzId.get()).toZoneId(this.timeZoneRegistry))).collect(Collectors.toList());
        }
        return this.dates.getDates();
    }

    @Override
    public void setValue(String aValue) {
        Optional tzId = this.getParameter("TZID");
        this.dates = tzId.isPresent() ? DateList.parse(aValue, (TzId)tzId.get(), this.timeZoneRegistry) : (this.defaultTimeZone != null ? DateList.parse(aValue, this.defaultTimeZone) : DateList.parse(aValue));
    }

    @Override
    public String getValue() {
        Optional tzId = this.getParameter("TZID");
        if (tzId.isPresent()) {
            return this.dates.toString(((TzId)tzId.get()).toZoneId(this.timeZoneRegistry));
        }
        return this.dates.toString();
    }

    public void setTimeZoneRegistry(TimeZoneRegistry timeZoneRegistry) {
        this.timeZoneRegistry = timeZoneRegistry;
    }

    public void setDefaultTimeZone(ZoneId defaultTimeZone) {
        this.defaultTimeZone = defaultTimeZone;
    }
}

