/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.util.Optional;
import net.fortuna.ical4j.model.CalendarDateFormat;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TemporalAdapter;
import net.fortuna.ical4j.model.TemporalComparator;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.UtcProperty;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.DatePropertyValidator;
import org.slf4j.LoggerFactory;

public abstract class DateProperty<T extends Temporal>
extends Property {
    private static final long serialVersionUID = 3160883132732961321L;
    private final CalendarDateFormat parseFormat;
    private final Value defaultValueParam;
    private TemporalAdapter<T> date;
    private transient TimeZoneRegistry timeZoneRegistry;
    private ZoneId defaultTimeZone;

    public DateProperty(String name, ParameterList parameters) {
        this(name, parameters, CalendarDateFormat.DEFAULT_PARSE_FORMAT, Value.DATE_TIME);
    }

    public DateProperty(String name, ParameterList parameters, CalendarDateFormat parseFormat, Value defaultValueParam) {
        super(name, parameters);
        this.parseFormat = parseFormat;
        this.defaultValueParam = defaultValueParam;
    }

    public DateProperty(Enum<?> name, ParameterList parameters, CalendarDateFormat parseFormat, Value defaultValueParam) {
        super(name, parameters);
        this.parseFormat = parseFormat;
        this.defaultValueParam = defaultValueParam;
    }

    public DateProperty(String name) {
        this(name, CalendarDateFormat.DEFAULT_PARSE_FORMAT, Value.DATE_TIME);
    }

    public DateProperty(String name, CalendarDateFormat parseFormat, Value defaultValueParam) {
        super(name);
        this.parseFormat = parseFormat;
        this.defaultValueParam = defaultValueParam;
    }

    public DateProperty(Enum<?> name, CalendarDateFormat parseFormat, Value defaultValueParam) {
        super(name);
        this.parseFormat = parseFormat;
        this.defaultValueParam = defaultValueParam;
    }

    public T getDate() {
        if (this.date != null) {
            Optional tzId = this.getParameter("TZID");
            if (tzId.isPresent() && this.shouldApplyTimezone()) {
                return (T)this.date.toLocalTime(((TzId)tzId.get()).toZoneId(this.timeZoneRegistry));
            }
            return this.date.getTemporal();
        }
        return null;
    }

    public void setDate(T date) {
        if (date != null) {
            this.date = new TemporalAdapter<T>(date, this.timeZoneRegistry);
            this.refreshParameters();
        } else {
            this.date = null;
        }
    }

    @Override
    public void setValue(String value) throws DateTimeParseException {
        if (value != null && !value.isEmpty()) {
            Optional tzId = this.getParameter("TZID");
            try {
                if (tzId.isPresent()) {
                    this.date = TemporalAdapter.parse(value, (TzId)tzId.get(), this.timeZoneRegistry);
                }
                if (this.defaultTimeZone != null) {
                    this.date = TemporalAdapter.parse(value, this.defaultTimeZone);
                }
                this.date = TemporalAdapter.parse(value, this.parseFormat);
            }
            catch (DateTimeParseException dtpe) {
                if (CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed")) {
                    LoggerFactory.getLogger(DateProperty.class).debug("Invalid DATE-TIME format", (Throwable)dtpe);
                    this.date = tzId.map(id -> TemporalAdapter.parse(value, id, this.timeZoneRegistry)).orElseGet(() -> TemporalAdapter.parse(value, CalendarDateFormat.DEFAULT_PARSE_FORMAT));
                }
                throw dtpe;
            }
        } else {
            this.date = null;
        }
    }

    @Override
    public String getValue() {
        Optional tzId = this.getParameter("TZID");
        if (tzId.isPresent() && this.shouldApplyTimezone()) {
            return this.date.toString(((TzId)tzId.get()).toZoneId(this.timeZoneRegistry));
        }
        if (this instanceof UtcProperty) {
            return this.date.toString(ZoneOffset.UTC);
        }
        return Strings.valueOf(this.date);
    }

    public void setTimeZoneRegistry(TimeZoneRegistry timeZoneRegistry) {
        this.timeZoneRegistry = timeZoneRegistry;
    }

    public void refreshParameters() {
        T temporal = this.date.getTemporal();
        if (!TemporalAdapter.isDateTimePrecision(temporal)) {
            if (Value.DATE.equals(this.defaultValueParam)) {
                this.removeAll("VALUE");
            } else {
                this.replace(Value.DATE);
            }
            this.removeAll("TZID");
        } else if (temporal instanceof ZonedDateTime) {
            if (Value.DATE_TIME.equals(this.defaultValueParam)) {
                this.removeAll("VALUE");
            } else {
                this.replace(Value.DATE_TIME);
            }
            if (TemporalAdapter.isUtc(temporal)) {
                this.removeAll("TZID");
            } else {
                ZoneId zoneId = ((ZonedDateTime)temporal).getZone();
                this.replace(new TzId(zoneId.getId()));
            }
        }
    }

    public void setDefaultTimeZone(ZoneId defaultTimeZone) {
        this.defaultTimeZone = defaultTimeZone;
    }

    private boolean shouldApplyTimezone() {
        Optional value = this.getParameter("VALUE");
        return !Optional.of(Value.DATE).equals(value);
    }

    @Override
    public int hashCode() {
        return this.getDate() != null ? this.getDate().hashCode() : 0;
    }

    public final boolean isUtc() {
        return this.date != null && TemporalAdapter.isUtc(this.date.getTemporal());
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return new DatePropertyValidator<DateProperty>().validate(this);
    }

    @Override
    public int compareTo(Property o) {
        if (o instanceof DateProperty) {
            return TemporalComparator.INSTANCE.compare((Temporal)this.getDate(), (Temporal)((DateProperty)o).getDate());
        }
        return super.compareTo(o);
    }
}

