/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import net.fortuna.ical4j.model.CalendarDateFormat;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.TemporalComparator;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.UtcProperty;
import net.fortuna.ical4j.util.CompatibilityHints;

public class DtStamp
extends DateProperty<Instant>
implements UtcProperty {
    private static final long serialVersionUID = 7581197869433744070L;

    public DtStamp() {
        this(Instant.now());
    }

    public DtStamp(String aValue) {
        this(new ParameterList(), aValue);
    }

    public DtStamp(ParameterList aList, String aValue) {
        super("DTSTAMP", aList, CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed") ? CalendarDateFormat.RELAXED_DATE_TIME_FORMAT : CalendarDateFormat.UTC_DATE_TIME_FORMAT, Value.DATE_TIME);
        this.setValue(aValue);
    }

    public DtStamp(Instant aDate) {
        super("DTSTAMP", CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed") ? CalendarDateFormat.RELAXED_DATE_TIME_FORMAT : CalendarDateFormat.UTC_DATE_TIME_FORMAT, Value.DATE_TIME);
        this.setDate(aDate);
    }

    public DtStamp(ParameterList aList, Instant aDate) {
        super("DTSTAMP", aList, CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed") ? CalendarDateFormat.RELAXED_DATE_TIME_FORMAT : CalendarDateFormat.UTC_DATE_TIME_FORMAT, Value.DATE_TIME);
        this.setDate(aDate);
    }

    @Override
    public int compareTo(Property o) {
        if (o instanceof DateProperty) {
            return TemporalComparator.INSTANCE.compare((Temporal)this.getDate(), (Temporal)((DateProperty)o).getDate());
        }
        return super.compareTo(o);
    }

    @Override
    public void setTimeZoneRegistry(TimeZoneRegistry timeZoneRegistry) {
        UtcProperty.super.setTimeZoneRegistry(timeZoneRegistry);
    }

    @Override
    public void setDefaultTimeZone(ZoneId defaultTimeZone) {
        UtcProperty.super.setDefaultTimeZone(defaultTimeZone);
    }

    protected PropertyFactory<DtStamp> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<DtStamp> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("DTSTAMP");
        }

        @Override
        public DtStamp createProperty(ParameterList parameters, String value) {
            return new DtStamp(parameters, value);
        }

        @Override
        public DtStamp createProperty() {
            return new DtStamp();
        }
    }
}

