/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Date;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.TemporalAmountAdapter;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.DateTimePropertyValidators;

public class Duration
extends Property {
    private static final long serialVersionUID = 9144969653829796798L;
    private TemporalAmountAdapter duration;

    public Duration() {
        super("DURATION");
    }

    public Duration(String value) {
        super("DURATION");
        this.setValue(value);
    }

    public Duration(ParameterList aList, String aValue) {
        super("DURATION", aList);
        this.setValue(aValue);
    }

    @Deprecated
    public Duration(Dur duration) {
        this(TemporalAmountAdapter.from(duration).getDuration());
    }

    public Duration(TemporalAmount duration) {
        super("DURATION");
        this.duration = new TemporalAmountAdapter(duration);
    }

    @Deprecated
    public Duration(ParameterList aList, Dur duration) {
        this(aList, TemporalAmountAdapter.from(duration).getDuration());
    }

    public Duration(ParameterList aList, TemporalAmount duration) {
        super("DURATION", aList);
        this.setDuration(duration);
    }

    @Deprecated
    public Duration(Date start, Date end) {
        super("DURATION");
        this.setDuration(TemporalAmountAdapter.fromDateRange(start, end).getDuration());
    }

    public Duration(Temporal start, Temporal end) {
        super("DURATION");
        this.setDuration(TemporalAmountAdapter.from(start, end).getDuration());
    }

    public final TemporalAmount getDuration() {
        return this.duration.getDuration();
    }

    @Override
    public final void setValue(String aValue) {
        this.duration = TemporalAmountAdapter.parse(aValue);
    }

    @Override
    public final String getValue() {
        return this.duration.toString();
    }

    public final void setDuration(TemporalAmount duration) {
        this.duration = new TemporalAmountAdapter(duration);
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return DateTimePropertyValidators.DURATION.validate(this);
    }

    protected PropertyFactory<Duration> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Duration> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("DURATION");
        }

        @Override
        public Duration createProperty(ParameterList parameters, String value) {
            return new Duration(parameters, value);
        }

        @Override
        public Duration createProperty() {
            return new Duration();
        }
    }
}

