/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.util.ArrayList;
import java.util.List;
import net.fortuna.ical4j.model.CalendarDateFormat;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.DateTimePropertyValidators;
import org.threeten.extra.Interval;

public class FreeBusy
extends Property {
    private static final long serialVersionUID = -6415954847619338567L;
    private List<Interval> intervals;

    public FreeBusy() {
        super("FREEBUSY");
        this.intervals = new ArrayList<Interval>();
    }

    public FreeBusy(String aValue) {
        super("FREEBUSY");
        this.setValue(aValue);
    }

    public FreeBusy(ParameterList aList, String aValue) {
        super("FREEBUSY", aList);
        this.setValue(aValue);
    }

    public FreeBusy(List<Interval> pList) {
        super("FREEBUSY");
        this.intervals = new ArrayList<Interval>(pList);
    }

    public FreeBusy(ParameterList aList, List<Interval> pList) {
        super("FREEBUSY", aList);
        this.intervals = new ArrayList<Interval>(pList);
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return DateTimePropertyValidators.FREEBUSY.validate(this);
    }

    public final List<Interval> getIntervals() {
        return new ArrayList<Interval>(this.intervals);
    }

    @Override
    public final void setValue(String aValue) {
        this.intervals = PeriodList.parse(aValue, CalendarDateFormat.UTC_DATE_TIME_FORMAT).toIntervalList();
    }

    @Override
    public final String getValue() {
        return new PeriodList((Interval[])this.intervals.toArray(Interval[]::new)).toString();
    }

    protected PropertyFactory<FreeBusy> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<FreeBusy> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("FREEBUSY");
        }

        @Override
        public FreeBusy createProperty(ParameterList parameters, String value) {
            return new FreeBusy(parameters, value);
        }

        @Override
        public FreeBusy createProperty() {
            return new FreeBusy();
        }
    }
}

