/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.DescriptivePropertyValidators;

public class Geo
extends Property {
    private static final long serialVersionUID = -902100715801867636L;
    private static final Pattern VALUE_PATTERN = Pattern.compile("([+-]?[0-9]+\\.?[0-9]*);([+-]?[0-9]+\\.?[0-9]*)");
    private static final Pattern RELAXED_VALUE_PATTERN = Pattern.compile("([+-]?[0-9]+\\.?[0-9]*)\\\\?;([+-]?[0-9]+\\.?[0-9]*)");
    private BigDecimal latitude;
    private BigDecimal longitude;

    public Geo() {
        super("GEO");
        this.latitude = BigDecimal.valueOf(0L);
        this.longitude = BigDecimal.valueOf(0L);
    }

    public Geo(String value) {
        super("GEO");
        this.setValue(value);
    }

    public Geo(ParameterList aList, String aValue) {
        super("GEO", aList);
        this.setValue(aValue);
    }

    public Geo(BigDecimal latitude, BigDecimal longitude) {
        super("GEO");
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public Geo(ParameterList aList, BigDecimal latitude, BigDecimal longitude) {
        super("GEO", aList);
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public final BigDecimal getLatitude() {
        return this.latitude;
    }

    public final BigDecimal getLongitude() {
        return this.longitude;
    }

    @Override
    public final void setValue(String aValue) {
        Matcher matcher = CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed") ? RELAXED_VALUE_PATTERN.matcher(aValue) : VALUE_PATTERN.matcher(aValue);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid GEO string");
        }
        String latitudeString = matcher.group(1);
        this.latitude = new BigDecimal(latitudeString);
        String longitudeString = matcher.group(2);
        this.longitude = new BigDecimal(longitudeString);
    }

    @Override
    public final String getValue() {
        return this.getLatitude() + ";" + this.getLongitude();
    }

    public final void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public final void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    protected PropertyFactory<Geo> newFactory() {
        return new Factory();
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return DescriptivePropertyValidators.GEO.validate(this);
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Geo> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("GEO");
        }

        @Override
        public Geo createProperty(ParameterList parameters, String value) {
            return new Geo(parameters, value);
        }

        @Override
        public Geo createProperty() {
            return new Geo();
        }
    }
}

