/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.Uris;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;

public class Link
extends Property {
    private static final String PROPERTY_NAME = "LINK";
    private URI uri;
    private String value;

    public Link() {
        super(PROPERTY_NAME);
    }

    public Link(Component component) {
        super(PROPERTY_NAME);
        Object componentUid = component.getRequiredProperty("UID");
        this.value = ((Content)componentUid).getValue();
        this.add(Value.UID);
    }

    public Link(URI uri) {
        super(PROPERTY_NAME);
        this.uri = uri;
    }

    public Link(String value) {
        super(PROPERTY_NAME, new ParameterList(Collections.singletonList(Value.UID)));
        this.value = value;
    }

    public Link(ParameterList aList, String value) {
        super(PROPERTY_NAME, aList);
        this.setValue(value);
    }

    public URI getUri() {
        return this.uri;
    }

    @Deprecated
    public String getText() {
        return this.value;
    }

    @Override
    public String getValue() {
        if (Value.XML_REFERENCE.equals(this.getRequiredParameter("VALUE")) || Value.URI.equals(this.getRequiredParameter("VALUE"))) {
            return Uris.decode(Strings.valueOf(this.getUri()));
        }
        return this.value;
    }

    @Override
    public void setValue(String aValue) {
        if (Value.XML_REFERENCE.equals(this.getRequiredParameter("VALUE")) || Value.URI.equals(this.getRequiredParameter("VALUE"))) {
            try {
                this.uri = Uris.create(aValue);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            this.value = null;
        } else {
            this.value = aValue;
            this.uri = null;
        }
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return null;
    }

    @Override
    protected PropertyFactory<?> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Link> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super(Link.PROPERTY_NAME);
        }

        @Override
        public Link createProperty(ParameterList parameters, String value) {
            return new Link(parameters, value);
        }

        @Override
        public Link createProperty() {
            return new Link();
        }
    }
}

