/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.property.immutable.ImmutableMethod;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.CalendarPropertyValidators;

public class Method
extends Property {
    private static final long serialVersionUID = 7220956532685378719L;
    public static final String VALUE_PUBLISH = "PUBLISH";
    public static final String VALUE_REQUEST = "REQUEST";
    public static final String VALUE_REPLY = "REPLY";
    public static final String VALUE_ADD = "ADD";
    public static final String VALUE_CANCEL = "CANCEL";
    public static final String VALUE_REFRESH = "REFRESH";
    public static final String VALUE_COUNTER = "COUNTER";
    public static final String VALUE_DECLINECOUNTER = "DECLINECOUNTER";
    private String value;

    public Method() {
        super("METHOD");
    }

    public Method(String aValue) {
        super("METHOD");
        this.value = aValue;
    }

    public Method(ParameterList aList, String aValue) {
        super("METHOD", aList);
        this.value = aValue;
    }

    @Override
    public void setValue(String aValue) {
        this.value = aValue;
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return CalendarPropertyValidators.METHOD.validate(this);
    }

    protected PropertyFactory<Method> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Method> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("METHOD");
        }

        @Override
        public Method createProperty(ParameterList parameters, String value) {
            if (parameters.getAll().isEmpty()) {
                switch (value.toUpperCase()) {
                    case "PUBLISH": {
                        return ImmutableMethod.PUBLISH;
                    }
                    case "REQUEST": {
                        return ImmutableMethod.REQUEST;
                    }
                    case "REPLY": {
                        return ImmutableMethod.REPLY;
                    }
                    case "ADD": {
                        return ImmutableMethod.ADD;
                    }
                    case "CANCEL": {
                        return ImmutableMethod.CANCEL;
                    }
                    case "REFRESH": {
                        return ImmutableMethod.REFRESH;
                    }
                    case "COUNTER": {
                        return ImmutableMethod.COUNTER;
                    }
                    case "DECLINECOUNTER": {
                        return ImmutableMethod.DECLINE_COUNTER;
                    }
                }
            }
            return new Method(parameters, value);
        }

        @Override
        public Method createProperty() {
            return new Method();
        }
    }
}

