/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.Uris;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.RelationshipPropertyValidators;

public class Organizer
extends Property {
    private static final long serialVersionUID = -5216965653165090725L;
    private URI calAddress;

    public Organizer() {
        super("ORGANIZER");
    }

    public Organizer(String value) {
        super("ORGANIZER");
        this.setValue(value);
    }

    public Organizer(ParameterList aList, String aValue) {
        super("ORGANIZER", aList);
        this.setValue(aValue);
    }

    public Organizer(URI aUri) {
        super("ORGANIZER");
        this.calAddress = aUri;
    }

    public Organizer(ParameterList aList, URI aUri) {
        super("ORGANIZER", aList);
        this.calAddress = aUri;
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return RelationshipPropertyValidators.ORGANIZER.validate(this);
    }

    public final URI getCalAddress() {
        return this.calAddress;
    }

    @Override
    public final void setValue(String aValue) {
        try {
            this.calAddress = Uris.create(aValue);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public final String getValue() {
        return Uris.decode(Strings.valueOf(this.getCalAddress()));
    }

    public final void setCalAddress(URI calAddress) {
        this.calAddress = calAddress;
    }

    protected PropertyFactory<Organizer> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Organizer> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("ORGANIZER");
        }

        @Override
        public Organizer createProperty(ParameterList parameters, String value) {
            return new Organizer(parameters, value);
        }

        @Override
        public Organizer createProperty() {
            return new Organizer();
        }
    }
}

