/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.property.immutable.ImmutablePriority;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.DescriptivePropertyValidators;

public class Priority
extends Property {
    private static final long serialVersionUID = -5654367843953827397L;
    public static final int VALUE_UNDEFINED = 0;
    public static final int VALUE_HIGH = 1;
    public static final int VALUE_MEDIUM = 5;
    public static final int VALUE_LOW = 9;
    private int level;

    public Priority() {
        super("PRIORITY");
        this.level = ImmutablePriority.UNDEFINED.getLevel();
    }

    public Priority(ParameterList aList, String aValue) {
        super("PRIORITY", aList);
        try {
            this.level = Integer.parseInt(aValue);
        }
        catch (NumberFormatException e) {
            if (CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed")) {
                this.level = ImmutablePriority.UNDEFINED.level;
            }
            throw e;
        }
    }

    public Priority(int aLevel) {
        super("PRIORITY");
        this.level = aLevel;
    }

    public Priority(ParameterList aList, int aLevel) {
        super("PRIORITY", aList);
        this.level = aLevel;
    }

    public final int getLevel() {
        return this.level;
    }

    @Override
    public void setValue(String aValue) {
        this.level = Integer.parseInt(aValue);
    }

    @Override
    public final String getValue() {
        return String.valueOf(this.getLevel());
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return DescriptivePropertyValidators.PRIORITY.validate(this);
    }

    protected PropertyFactory<Priority> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Priority> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("PRIORITY");
        }

        @Override
        public Priority createProperty(ParameterList parameters, String value) {
            if (parameters.getAll().isEmpty()) {
                try {
                    int level = Integer.parseInt(value);
                    switch (level) {
                        case 0: {
                            return ImmutablePriority.UNDEFINED;
                        }
                        case 1: {
                            return ImmutablePriority.HIGH;
                        }
                        case 5: {
                            return ImmutablePriority.MEDIUM;
                        }
                        case 9: {
                            return ImmutablePriority.LOW;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    if (CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed")) {
                        return ImmutablePriority.UNDEFINED;
                    }
                    throw new IllegalArgumentException(e);
                }
            }
            return new Priority(parameters, value);
        }

        @Override
        public Priority createProperty() {
            return new Priority();
        }
    }
}

