/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.time.temporal.Temporal;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DateListProperty;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.RecurrencePropertyValidators;

public class RDate<T extends Temporal>
extends DateListProperty<T> {
    private static final long serialVersionUID = -3320381650013860193L;
    private PeriodList<T> periods;

    public RDate() {
        super("RDATE");
        this.periods = null;
    }

    public RDate(ParameterList aList, String aValue) {
        super("RDATE", aList, Value.DATE_TIME);
        this.periods = null;
        this.setValue(aValue);
    }

    public RDate(DateList<T> dates) {
        super("RDATE", dates);
        this.periods = null;
    }

    public RDate(ParameterList aList, DateList<T> dates) {
        super("RDATE", aList, dates, Value.DATE_TIME);
        this.periods = null;
    }

    public RDate(List<Period<T>> periods) {
        super("RDATE", new DateList());
        this.periods = new PeriodList<T>(periods);
    }

    public RDate(ParameterList aList, List<Period<T>> periods) {
        super("RDATE", aList, new DateList(), Value.DATE_TIME);
        this.periods = new PeriodList<T>(periods);
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return RecurrencePropertyValidators.RDATE.validate(this);
    }

    public final Optional<Set<Period<T>>> getPeriods() {
        if (this.periods != null) {
            return Optional.of(this.periods.getPeriods());
        }
        return Optional.empty();
    }

    @Override
    public final void setValue(String aValue) {
        if (this.getParameter("VALUE").equals(Optional.of(Value.PERIOD))) {
            this.periods = PeriodList.parse(aValue);
        } else {
            super.setValue(aValue);
        }
    }

    @Override
    public final String getValue() {
        if (this.periods != null) {
            return Strings.valueOf(this.periods);
        }
        return super.getValue();
    }

    protected PropertyFactory<RDate<T>> newFactory() {
        return new Factory();
    }

    public static class Factory<T extends Temporal>
    extends Content.Factory
    implements PropertyFactory<RDate<T>> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("RDATE");
        }

        @Override
        public RDate<T> createProperty(ParameterList parameters, String value) {
            return new RDate(parameters, value);
        }

        @Override
        public RDate<T> createProperty() {
            return new RDate();
        }
    }
}

