/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.time.temporal.Temporal;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.transform.recurrence.Frequency;
import net.fortuna.ical4j.validate.RecurValidator;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.RecurrencePropertyValidators;

public class RRule<T extends Temporal>
extends Property {
    private static final long serialVersionUID = -9188265089143001164L;
    private Recur<T> recur;

    public RRule() {
        super("RRULE");
    }

    public RRule(Frequency frequency) {
        super("RRULE");
        this.recur = new Recur(frequency);
    }

    public RRule(String value) {
        super("RRULE");
        this.setValue(value);
    }

    public RRule(ParameterList aList, String aValue) {
        super("RRULE", aList);
        this.setValue(aValue);
    }

    public RRule(Recur<T> aRecur) {
        super("RRULE");
        this.recur = aRecur;
    }

    public RRule(ParameterList aList, Recur<T> aRecur) {
        super("RRULE", aList);
        this.recur = aRecur;
    }

    public final Recur<T> getRecur() {
        return this.recur;
    }

    public void setRecur(Recur<T> recur) {
        this.recur = recur;
    }

    @Override
    public void setValue(String aValue) {
        this.recur = new Recur(aValue);
    }

    @Override
    public final String getValue() {
        return this.getRecur().toString();
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return new RecurValidator().validate(this.recur).merge(RecurrencePropertyValidators.RRULE.validate(this));
    }

    protected PropertyFactory<RRule<T>> newFactory() {
        return new Factory();
    }

    public static class Factory<T extends Temporal>
    extends Content.Factory
    implements PropertyFactory<RRule<T>> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("RRULE");
        }

        @Override
        public RRule<T> createProperty(ParameterList parameters, String value) {
            return new RRule(parameters, value);
        }

        @Override
        public RRule<T> createProperty() {
            return new RRule();
        }
    }
}

