/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.time.temporal.TemporalAmount;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.TemporalAmountAdapter;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;

public class RefreshInterval
extends Property {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_NAME = "REFRESH-INTERVAL";
    private TemporalAmountAdapter duration;

    public RefreshInterval() {
        super(PROPERTY_NAME);
    }

    public RefreshInterval(ParameterList params, String value) {
        super(PROPERTY_NAME, params);
        this.setValue(value);
    }

    public RefreshInterval(ParameterList params, TemporalAmount duration) {
        super(PROPERTY_NAME, params);
        this.duration = new TemporalAmountAdapter(duration);
    }

    @Override
    public void setValue(String aValue) {
        this.duration = TemporalAmountAdapter.parse(aValue);
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return ValidationResult.EMPTY;
    }

    @Override
    public String getValue() {
        return this.duration.toString();
    }

    protected PropertyFactory<RefreshInterval> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<RefreshInterval> {
        public Factory() {
            super(RefreshInterval.PROPERTY_NAME);
        }

        @Override
        public RefreshInterval createProperty() {
            return new RefreshInterval();
        }

        @Override
        public RefreshInterval createProperty(ParameterList parameters, String value) {
            return new RefreshInterval(parameters, value);
        }
    }
}

