/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.Uris;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.RelationshipPropertyValidators;

public class RelatedTo
extends Property
implements Encodable {
    private static final long serialVersionUID = -109375299147319752L;
    private URI uri;
    private String value;

    public RelatedTo() {
        super("RELATED-TO");
    }

    public RelatedTo(URI uri) {
        super("RELATED-TO");
        this.uri = uri;
    }

    public RelatedTo(String aValue) {
        super("RELATED-TO");
        this.setValue(aValue);
    }

    public RelatedTo(ParameterList aList, String aValue) {
        super("RELATED-TO", aList);
        this.setValue(aValue);
    }

    public RelatedTo(Component component) {
        super("RELATED-TO");
        this.setValue(((Content)component.getRequiredProperty("UID")).getValue());
    }

    public RelatedTo(ParameterList parameters, Component component) {
        super("RELATED-TO", parameters);
        this.setValue(((Content)component.getRequiredProperty("UID")).getValue());
    }

    @Override
    public final void setValue(String aValue) {
        if (Optional.of(Value.URI).equals(this.getParameter("VALUE"))) {
            try {
                this.uri = Uris.create(aValue);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            this.value = null;
        } else {
            this.value = aValue;
            this.uri = null;
        }
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public final String getValue() {
        if (Optional.of(Value.URI).equals(this.getParameter("VALUE"))) {
            return Uris.decode(Strings.valueOf(this.getUri()));
        }
        return this.value;
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return RelationshipPropertyValidators.RELATED_TO.validate(this);
    }

    protected PropertyFactory<RelatedTo> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<RelatedTo> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("RELATED-TO");
        }

        @Override
        public RelatedTo createProperty(ParameterList parameters, String value) {
            return new RelatedTo(parameters, value);
        }

        @Override
        public RelatedTo createProperty() {
            return new RelatedTo();
        }
    }
}

