/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.validate.PropertyValidator;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;

public class RequestStatus
extends Property {
    private static final long serialVersionUID = -3273944031884755345L;
    public static final String PRELIM_SUCCESS = "1";
    public static final String SUCCESS = "2";
    public static final String CLIENT_ERROR = "3";
    public static final String SCHEDULING_ERROR = "4";
    private String statusCode;
    private String description;
    private String exData;

    public RequestStatus() {
        super("REQUEST-STATUS");
    }

    public RequestStatus(ParameterList aList, String aValue) {
        super("REQUEST-STATUS", aList);
        this.setValue(aValue);
    }

    public RequestStatus(String aStatusCode, String aDescription, String data) {
        super("REQUEST-STATUS");
        this.statusCode = aStatusCode;
        this.description = aDescription;
        this.exData = data;
    }

    public RequestStatus(ParameterList aList, String aStatusCode, String aDescription, String data) {
        super("REQUEST-STATUS", aList);
        this.statusCode = aStatusCode;
        this.description = aDescription;
        this.exData = data;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getExData() {
        return this.exData;
    }

    public final String getStatusCode() {
        return this.statusCode;
    }

    @Override
    public final void setValue(String aValue) {
        String[] values = aValue.split(";");
        if (values.length > 0) {
            this.statusCode = values[0];
        }
        if (values.length > 1) {
            this.description = values[1];
        }
        if (values.length > 2) {
            this.exData = values[2];
        }
    }

    @Override
    public final String getValue() {
        StringBuilder b = new StringBuilder();
        if (this.getStatusCode() != null) {
            b.append(this.getStatusCode());
        }
        if (this.getDescription() != null) {
            b.append(';').append(this.getDescription());
        }
        if (this.getExData() != null) {
            b.append(';').append(this.getExData());
        }
        return b.toString();
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final void setExData(String exData) {
        this.exData = exData;
    }

    public final void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return PropertyValidator.REQUEST_STATUS.validate(this);
    }

    protected PropertyFactory<RequestStatus> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<RequestStatus> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("REQUEST-STATUS");
        }

        @Override
        public RequestStatus createProperty(ParameterList parameters, String value) {
            return new RequestStatus(parameters, value);
        }

        @Override
        public RequestStatus createProperty() {
            return new RequestStatus();
        }
    }
}

