/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.util.Comparator;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.ChangeManagementPropertyValidators;

public class Sequence
extends Property {
    private static final long serialVersionUID = -1606972893204822853L;
    private int sequenceNo;

    public Sequence() {
        super("SEQUENCE");
        this.sequenceNo = 0;
    }

    public Sequence(String aValue) {
        super("SEQUENCE");
        this.setValue(aValue);
    }

    public Sequence(ParameterList aList, String aValue) {
        super("SEQUENCE", aList);
        this.setValue(aValue);
    }

    public Sequence(int aSequenceNo) {
        super("SEQUENCE");
        this.sequenceNo = aSequenceNo;
    }

    public Sequence(ParameterList aList, int aSequenceNo) {
        super("SEQUENCE", aList);
        this.sequenceNo = aSequenceNo;
    }

    public final int getSequenceNo() {
        return this.sequenceNo;
    }

    @Override
    public final void setValue(String aValue) {
        this.sequenceNo = Integer.parseInt(aValue);
    }

    @Override
    public final String getValue() {
        return String.valueOf(this.getSequenceNo());
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return ChangeManagementPropertyValidators.SEQUENCE.validate(this);
    }

    @Override
    public int compareTo(Property o) {
        if (o instanceof Sequence) {
            return Comparator.comparing(Property::getName).thenComparing(Sequence::getSequenceNo).compare(this, (Sequence)o);
        }
        return super.compareTo(o);
    }

    protected PropertyFactory<Sequence> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Sequence> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("SEQUENCE");
        }

        @Override
        public Sequence createProperty(ParameterList parameters, String value) {
            return new Sequence(parameters, value);
        }

        @Override
        public Sequence createProperty() {
            return new Sequence();
        }
    }
}

