/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.property.immutable.ImmutableStatus;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.DescriptivePropertyValidators;

public class Status
extends Property {
    private static final long serialVersionUID = 7401102230299289898L;
    public static final String VALUE_TENTATIVE = "TENTATIVE";
    public static final String VALUE_CONFIRMED = "CONFIRMED";
    public static final String VALUE_CANCELLED = "CANCELLED";
    public static final String VALUE_NEEDS_ACTION = "NEEDS-ACTION";
    public static final String VALUE_COMPLETED = "COMPLETED";
    public static final String VALUE_IN_PROCESS = "IN-PROCESS";
    public static final String VALUE_DRAFT = "DRAFT";
    public static final String VALUE_FINAL = "FINAL";
    private String value;

    public Status() {
        super("STATUS");
    }

    public Status(String aValue) {
        super("STATUS");
        this.value = aValue;
    }

    public Status(ParameterList aList, String aValue) {
        super("STATUS", aList);
        this.value = aValue;
    }

    @Override
    public void setValue(String aValue) {
        this.value = aValue;
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return DescriptivePropertyValidators.STATUS.validate(this);
    }

    protected PropertyFactory<Status> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Status> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("STATUS");
        }

        @Override
        public Status createProperty(ParameterList parameters, String value) {
            if (parameters.getAll().isEmpty()) {
                switch (value.toUpperCase()) {
                    case "TENTATIVE": {
                        return ImmutableStatus.VEVENT_TENTATIVE;
                    }
                    case "CONFIRMED": {
                        return ImmutableStatus.VEVENT_CONFIRMED;
                    }
                    case "CANCELLED": {
                        return ImmutableStatus.VEVENT_CANCELLED;
                    }
                    case "NEEDS-ACTION": {
                        return ImmutableStatus.VTODO_NEEDS_ACTION;
                    }
                    case "COMPLETED": {
                        return ImmutableStatus.VTODO_COMPLETED;
                    }
                    case "IN-PROCESS": {
                        return ImmutableStatus.VTODO_IN_PROCESS;
                    }
                    case "DRAFT": {
                        return ImmutableStatus.VJOURNAL_DRAFT;
                    }
                    case "FINAL": {
                        return ImmutableStatus.VJOURNAL_FINAL;
                    }
                }
            }
            return new Status(parameters, value);
        }

        @Override
        public Status createProperty() {
            return new Status();
        }
    }
}

