/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.parameter.Encoding;
import net.fortuna.ical4j.model.parameter.Schema;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.util.DecoderFactory;
import net.fortuna.ical4j.util.EncoderFactory;
import net.fortuna.ical4j.util.Uris;
import net.fortuna.ical4j.validate.PropertyValidator;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.schema.SchemaValidatorFactory;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructuredData
extends Property
implements Encodable {
    private static final long serialVersionUID = 7287564228220558361L;
    private String value;
    private URI uri;
    private byte[] binary;

    public StructuredData() {
        super("STRUCTURED-DATA", new ParameterList());
    }

    public StructuredData(String aValue) {
        super("STRUCTURED-DATA", new ParameterList());
        this.setValue(aValue);
    }

    public StructuredData(ParameterList aList, String aValue) {
        super("STRUCTURED-DATA", aList);
        this.setValue(aValue);
    }

    public StructuredData(URI uri) {
        super("STRUCTURED-DATA", new ParameterList(Collections.singletonList(Value.URI)));
        this.uri = uri;
    }

    public StructuredData(byte[] binary) {
        super("STRUCTURED-DATA", new ParameterList(Arrays.asList(Value.BINARY, Encoding.BASE64)));
        this.binary = binary;
    }

    @Override
    public final void setValue(String aValue) {
        if (!this.getParameters("ENCODING").isEmpty()) {
            try {
                BinaryDecoder decoder = DecoderFactory.getInstance().createBinaryDecoder((Encoding)this.getRequiredParameter("ENCODING"));
                this.binary = decoder.decode(aValue.getBytes());
            }
            catch (UnsupportedEncodingException uee) {
                Logger log = LoggerFactory.getLogger(Attach.class);
                log.error("Error encoding binary data", (Throwable)uee);
            }
            catch (DecoderException de) {
                Logger log = LoggerFactory.getLogger(Attach.class);
                log.error("Error decoding binary data", (Throwable)de);
            }
        } else if (Value.URI.equals(this.getRequiredParameter("VALUE"))) {
            try {
                this.uri = Uris.create(aValue);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            this.value = aValue;
        } else {
            this.value = aValue;
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    @Override
    public final String getValue() {
        Optional valueParam = this.getParameter("VALUE");
        if (valueParam.isPresent()) {
            if (Value.URI.equals(valueParam.get())) {
                return this.uri.toString();
            }
            if (Value.BINARY.equals(valueParam.get())) {
                try {
                    BinaryEncoder encoder = EncoderFactory.getInstance().createBinaryEncoder((Encoding)this.getRequiredParameter("ENCODING"));
                    return new String(encoder.encode(this.binary));
                }
                catch (UnsupportedEncodingException | EncoderException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.value;
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        ValidationResult result = PropertyValidator.STRUCTURED_DATA.validate(this);
        result = result.merge(SchemaValidatorFactory.newInstance((Schema)this.getRequiredParameter("SCHEMA")).validate(this));
        return result;
    }

    protected PropertyFactory<StructuredData> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<StructuredData> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("STRUCTURED-DATA");
        }

        @Override
        public StructuredData createProperty(ParameterList parameters, String value) {
            return new StructuredData(parameters, value);
        }

        @Override
        public StructuredData createProperty() {
            return new StructuredData();
        }
    }
}

