/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.util.Uris;
import net.fortuna.ical4j.validate.PropertyValidator;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;

public class StyledDescription
extends Property
implements Encodable {
    private static final long serialVersionUID = 7287564228220558361L;
    private String value;
    private URI uriValue;

    public StyledDescription() {
        super("STYLED-DESCRIPTION", new ParameterList());
    }

    public StyledDescription(String aValue) {
        super("STYLED-DESCRIPTION", new ParameterList());
        this.setValue(aValue);
    }

    public StyledDescription(ParameterList aList, String aValue) {
        super("STYLED-DESCRIPTION", aList);
        this.setValue(aValue);
    }

    @Override
    public final void setValue(String aValue) {
        if (Optional.of(Value.TEXT).equals(this.getParameter("VALUE"))) {
            this.value = aValue;
        } else if (Optional.of(Value.URI).equals(this.getParameter("VALUE"))) {
            try {
                this.uriValue = Uris.create(aValue);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            this.value = aValue;
        } else {
            throw new IllegalArgumentException("No valid VALUE parameter specified");
        }
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return PropertyValidator.STYLED_DESCRIPTION.validate(this);
    }

    protected PropertyFactory<StyledDescription> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<StyledDescription> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("STYLED-DESCRIPTION");
        }

        @Override
        public StyledDescription createProperty(ParameterList parameters, String value) {
            return new StyledDescription(parameters, value);
        }

        @Override
        public StyledDescription createProperty() {
            return new StyledDescription();
        }
    }
}

