/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.property.immutable.ImmutableTransp;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.DateTimePropertyValidators;

public class Transp
extends Property {
    private static final long serialVersionUID = 3801479657311785518L;
    public static final String VALUE_OPAQUE = "OPAQUE";
    public static final String VALUE_TRANSPARENT = "TRANSPARENT";
    private String value;

    public Transp() {
        super("TRANSP");
    }

    public Transp(String aValue) {
        super("TRANSP");
        this.value = aValue;
    }

    public Transp(ParameterList aList, String aValue) {
        super("TRANSP", aList);
        this.value = aValue;
    }

    @Override
    public void setValue(String aValue) {
        this.value = aValue;
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return DateTimePropertyValidators.TRANSP.validate(this);
    }

    protected PropertyFactory<Transp> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Transp> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("TRANSP");
        }

        @Override
        public Transp createProperty(ParameterList parameters, String value) {
            Transp transp = parameters.getAll().isEmpty() && ImmutableTransp.OPAQUE.getValue().equalsIgnoreCase(value) ? ImmutableTransp.OPAQUE : (parameters.getAll().isEmpty() && ImmutableTransp.TRANSPARENT.getValue().equalsIgnoreCase(value) ? ImmutableTransp.TRANSPARENT : new Transp(parameters, value));
            return transp;
        }

        @Override
        public Transp createProperty() {
            return new Transp();
        }
    }
}

