/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAmount;
import java.util.Collections;
import java.util.Optional;
import net.fortuna.ical4j.model.CalendarDateFormat;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.TemporalAmountAdapter;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.UtcProperty;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.AlarmPropertyValidators;
import org.slf4j.LoggerFactory;

public class Trigger
extends DateProperty<Instant>
implements UtcProperty {
    private static final long serialVersionUID = 5049421499261722194L;
    private TemporalAmountAdapter duration;

    public Trigger() {
        this(Instant.now());
    }

    public Trigger(ParameterList aList, String aValue) {
        super("TRIGGER", aList, CalendarDateFormat.UTC_DATE_TIME_FORMAT, Value.DURATION);
        this.setValue(aValue);
    }

    @Deprecated
    public Trigger(Dur duration) {
        this(TemporalAmountAdapter.from(duration));
    }

    public Trigger(TemporalAmount duration) {
        this(new TemporalAmountAdapter(duration));
    }

    private Trigger(TemporalAmountAdapter duration) {
        super("TRIGGER", CalendarDateFormat.UTC_DATE_TIME_FORMAT, Value.DURATION);
        this.duration = duration;
    }

    @Deprecated
    public Trigger(ParameterList aList, Dur duration) {
        this(aList, TemporalAmountAdapter.from(duration));
    }

    public Trigger(ParameterList aList, TemporalAmount duration) {
        this(aList, new TemporalAmountAdapter(duration));
    }

    private Trigger(ParameterList aList, TemporalAmountAdapter duration) {
        super("TRIGGER", aList, CalendarDateFormat.UTC_DATE_TIME_FORMAT, Value.DURATION);
        this.duration = duration;
    }

    public Trigger(Instant dateTime) {
        super("TRIGGER", new ParameterList(Collections.singletonList(Value.DATE_TIME)), CalendarDateFormat.UTC_DATE_TIME_FORMAT, Value.DURATION);
        this.setDate(dateTime);
    }

    public Trigger(ParameterList aList, Instant dateTime) {
        super("TRIGGER", aList, CalendarDateFormat.UTC_DATE_TIME_FORMAT, Value.DURATION);
        this.setDate(dateTime);
    }

    public boolean isAbsolute() {
        return Optional.of(Value.DATE_TIME).equals(this.getParameter("VALUE"));
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        ValidationResult result = super.validate();
        result = Optional.of(Value.DATE_TIME).equals(this.getParameter("VALUE")) ? result.merge(AlarmPropertyValidators.TRIGGER_ABS.validate(this)) : result.merge(AlarmPropertyValidators.TRIGGER_REL.validate(this));
        return result;
    }

    public final TemporalAmount getDuration() {
        if (this.duration != null) {
            return this.duration.getDuration();
        }
        return null;
    }

    @Override
    public final void setValue(String aValue) {
        try {
            super.setValue(aValue);
            this.duration = null;
        }
        catch (DateTimeParseException pe) {
            LoggerFactory.getLogger(Trigger.class).debug(String.format("Not a valid DATE-TIME value: %s", aValue));
            this.duration = TemporalAmountAdapter.parse(aValue);
            super.setDate(null);
        }
    }

    @Override
    public final String getValue() {
        if (this.duration != null) {
            return this.duration.toString();
        }
        return super.getValue();
    }

    @Override
    public void setDate(Instant dateTime) {
        super.setDate(dateTime);
        this.duration = null;
        this.replace(Value.DATE_TIME);
    }

    public final void setDuration(TemporalAmount duration) {
        this.duration = new TemporalAmountAdapter(duration);
        super.setDate(null);
        this.replace(Value.DURATION);
    }

    @Override
    public void setTimeZoneRegistry(TimeZoneRegistry timeZoneRegistry) {
        UtcProperty.super.setTimeZoneRegistry(timeZoneRegistry);
    }

    @Override
    public void setDefaultTimeZone(ZoneId defaultTimeZone) {
        UtcProperty.super.setDefaultTimeZone(defaultTimeZone);
    }

    protected PropertyFactory<Trigger> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Trigger> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("TRIGGER");
        }

        @Override
        public Trigger createProperty(ParameterList parameters, String value) {
            return new Trigger(parameters, value);
        }

        @Override
        public Trigger createProperty() {
            return new Trigger();
        }
    }
}

