/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.Uris;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.TimeZonePropertyValidators;

public class TzUrl
extends Property {
    private static final long serialVersionUID = 9106100107954797406L;
    private URI uri;

    public TzUrl() {
        super("TZURL");
    }

    public TzUrl(ParameterList aList, String aValue) {
        super("TZURL", aList);
        this.setValue(aValue);
    }

    public TzUrl(URI aUri) {
        super("TZURL");
        this.uri = aUri;
    }

    public TzUrl(ParameterList aList, URI aUri) {
        super("TZURL", aList);
        this.uri = aUri;
    }

    public final URI getUri() {
        return this.uri;
    }

    @Override
    public final void setValue(String aValue) {
        try {
            this.uri = Uris.create(aValue);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public final String getValue() {
        return Uris.decode(Strings.valueOf(this.getUri()));
    }

    public final void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return TimeZonePropertyValidators.TZURL.validate(this);
    }

    protected PropertyFactory<TzUrl> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<TzUrl> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("TZURL");
        }

        @Override
        public TzUrl createProperty(ParameterList parameters, String value) {
            return new TzUrl(parameters, value);
        }

        @Override
        public TzUrl createProperty() {
            return new TzUrl();
        }
    }
}

