/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.net.URI;
import java.net.URISyntaxException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.util.Uris;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.RelationshipPropertyValidators;

public class Url
extends Property {
    private static final long serialVersionUID = 1092576402256525737L;
    private URI uri;

    public Url() {
        super("URL");
    }

    public Url(ParameterList aList, String aValue) {
        super("URL", aList);
        this.setValue(aValue);
    }

    public Url(URI aUri) {
        super("URL");
        this.uri = aUri;
    }

    public Url(ParameterList aList, URI aUri) {
        super("URL", aList);
        this.uri = aUri;
    }

    public final URI getUri() {
        return this.uri;
    }

    @Override
    public final void setValue(String aValue) {
        try {
            this.uri = Uris.create(aValue);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public final String getValue() {
        return Uris.decode(Strings.valueOf(this.getUri()));
    }

    public final void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return RelationshipPropertyValidators.URL.validate(this);
    }

    protected PropertyFactory<Url> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Url> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("URL");
        }

        @Override
        public Url createProperty(ParameterList parameters, String value) {
            return new Url(parameters, value);
        }

        @Override
        public Url createProperty() {
            return new Url();
        }
    }
}

