/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.property.immutable.ImmutableVersion;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import net.fortuna.ical4j.validate.property.CalendarPropertyValidators;

public class Version
extends Property {
    private static final long serialVersionUID = 8872508067309087704L;
    public static final String VALUE_2_0 = "2.0";
    private String minVersion;
    private String maxVersion;

    public Version() {
        super("VERSION");
    }

    public Version(ParameterList aList, String aValue) {
        super("VERSION", aList);
        if (aValue.indexOf(59) >= 0) {
            this.minVersion = aValue.substring(0, aValue.indexOf(59) - 1);
            this.maxVersion = aValue.substring(aValue.indexOf(59));
        } else {
            this.maxVersion = aValue;
        }
    }

    public Version(String minVersion, String maxVersion) {
        super("VERSION");
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
    }

    public Version(ParameterList aList, String aVersion1, String aVersion2) {
        super("VERSION", aList);
        this.minVersion = aVersion1;
        this.maxVersion = aVersion2;
    }

    public final String getMaxVersion() {
        return this.maxVersion;
    }

    public final String getMinVersion() {
        return this.minVersion;
    }

    @Override
    public void setValue(String aValue) {
        if (aValue.indexOf(59) >= 0) {
            this.minVersion = aValue.substring(0, aValue.indexOf(59) - 1);
            this.maxVersion = aValue.substring(aValue.indexOf(59));
        } else {
            this.maxVersion = aValue;
        }
    }

    @Override
    public final String getValue() {
        StringBuilder b = new StringBuilder();
        if (this.getMinVersion() != null) {
            b.append(this.getMinVersion());
            if (this.getMaxVersion() != null) {
                b.append(';');
            }
        }
        if (this.getMaxVersion() != null) {
            b.append(this.getMaxVersion());
        }
        return b.toString();
    }

    public void setMaxVersion(String maxVersion) {
        this.maxVersion = maxVersion;
    }

    public void setMinVersion(String minVersion) {
        this.minVersion = minVersion;
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        return CalendarPropertyValidators.VERSION.validate(this);
    }

    protected PropertyFactory<Version> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Version> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("VERSION");
        }

        @Override
        public Version createProperty(ParameterList parameters, String value) {
            if (parameters.getAll().isEmpty() && Version.VALUE_2_0.equals(value)) {
                return ImmutableVersion.VERSION_2_0;
            }
            return new Version(parameters, value);
        }

        @Override
        public Version createProperty() {
            return new Version();
        }
    }
}

