/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.validate.ValidationEntry;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;

public class XProperty
extends Property
implements Encodable {
    private static final long serialVersionUID = 2331763266954894541L;
    private String value;

    public XProperty(String name) {
        super(name);
    }

    public XProperty(String aName, String aValue) {
        super(aName);
        this.setValue(aValue);
    }

    public XProperty(String aName, ParameterList aList, String aValue) {
        super(aName, aList);
        this.setValue(aValue);
    }

    @Override
    public final void setValue(String aValue) {
        this.value = aValue;
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        ValidationResult result = new ValidationResult(new ValidationEntry[0]);
        if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed") && !this.getName().startsWith("X-")) {
            result.getEntries().add(new ValidationEntry("Invalid name [" + this.getName() + "]. Experimental properties must have the following prefix: X-", ValidationEntry.Severity.ERROR, this.getName()));
        }
        return result;
    }

    protected PropertyFactory<XProperty> newFactory() {
        throw new UnsupportedOperationException("Factory not supported for custom properties");
    }
}

