/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Optional;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.Encodable;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.parameter.Encoding;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.util.DecoderFactory;
import net.fortuna.ical4j.validate.PropertyValidator;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.validate.ValidationResult;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.DecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Xml
extends Property
implements Encodable {
    private String value;
    private byte[] binary;

    public Xml() {
        super("XML");
    }

    public Xml(String aValue) throws URISyntaxException {
        super("XML");
        this.setValue(aValue);
    }

    public Xml(ParameterList aList, String aValue) {
        super("XML", aList);
        this.setValue(aValue);
    }

    public Xml(byte[] binary) {
        super("XML", new ParameterList(Arrays.asList(Value.BINARY, Encoding.BASE64)));
        this.binary = binary;
    }

    @Override
    public final void setValue(String aValue) {
        if (this.getParameter("ENCODING").isPresent()) {
            try {
                BinaryDecoder decoder = DecoderFactory.getInstance().createBinaryDecoder((Encoding)this.getRequiredParameter("ENCODING"));
                this.binary = decoder.decode(aValue.getBytes());
            }
            catch (UnsupportedEncodingException uee) {
                Logger log = LoggerFactory.getLogger(Attach.class);
                log.error("Error encoding binary data", (Throwable)uee);
            }
            catch (DecoderException de) {
                Logger log = LoggerFactory.getLogger(Attach.class);
                log.error("Error decoding binary data", (Throwable)de);
            }
        } else {
            this.value = aValue;
        }
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    @Override
    public ValidationResult validate() throws ValidationException {
        if (Optional.of(Value.BINARY).equals(this.getParameter("VALUE"))) {
            return PropertyValidator.XML_BIN.validate(this);
        }
        return PropertyValidator.XML.validate(this);
    }

    @Override
    protected PropertyFactory<?> newFactory() {
        return new Factory();
    }

    public static class Factory
    extends Content.Factory
    implements PropertyFactory<Xml> {
        private static final long serialVersionUID = 1L;

        public Factory() {
            super("XML");
        }

        @Override
        public Xml createProperty(ParameterList parameters, String value) {
            return new Xml(parameters, value);
        }

        @Override
        public Xml createProperty() {
            return new Xml();
        }
    }
}

