/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.transform.compliance;

import java.net.URI;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.transform.compliance.Rfc5545PropertyRule;
import org.apache.commons.lang3.StringUtils;

public class AttendeePropertyRule
implements Rfc5545PropertyRule<Attendee> {
    private static final String MAILTO = "mailto";
    private static final String APOSTROPHE = "'";
    private static final int MIN_LENGTH = 3;

    @Override
    public Attendee apply(Attendee element) {
        String part;
        if (element == null) {
            return element;
        }
        URI calAddress = element.getCalAddress();
        if (calAddress == null) {
            return element;
        }
        String scheme = calAddress.getScheme();
        if (scheme != null && StringUtils.startsWithIgnoreCase((CharSequence)scheme, (CharSequence)MAILTO) && (part = calAddress.getSchemeSpecificPart()) != null && part.length() >= 3 && StringUtils.startsWith((CharSequence)part, (CharSequence)APOSTROPHE) && StringUtils.endsWith((CharSequence)part, (CharSequence)APOSTROPHE)) {
            String newPart = part.substring(1, part.length() - 1);
            AttendeePropertyRule.safelySetNewValue(element, newPart);
        }
        return element;
    }

    private static void safelySetNewValue(Attendee element, String newPart) {
        element.setValue("mailto:" + newPart);
    }

    @Override
    public Class<Attendee> getSupportedType() {
        return Attendee.class;
    }
}

