/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.transform.compliance;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.property.DateProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TzHelper {
    private static final String MS_TIMEZONES_FILE = "msTimezones";
    private static final Map<String, String> MS_TIMEZONE_IDS = new HashMap<String, String>();
    private static final Map<String, String> MS_TIMEZONE_NAMES = new HashMap<String, String>();
    private static final TimeZoneRegistry TIMEZONE_REGISTRY;
    private static final Logger LOG;

    private static void initMsTimezones() {
        try (Scanner scanner = new Scanner(TzHelper.class.getResourceAsStream(MS_TIMEZONES_FILE));){
            while (scanner.hasNext()) {
                String[] arr = scanner.nextLine().split("=");
                String standardTzId = arr[1];
                String[] displayNameAndMsTzId = arr[0].split(";");
                MS_TIMEZONE_NAMES.put(displayNameAndMsTzId[0], standardTzId);
                MS_TIMEZONE_IDS.put(displayNameAndMsTzId[1], standardTzId);
            }
        }
        catch (RuntimeException e) {
            LOG.error("Could not load MS timezones", (Throwable)e);
            throw new RuntimeException("Unable to load resource file msTimezones", e);
        }
    }

    static void correctTzParameterFrom(Property property) {
        if (!property.getParameter("TZID").isPresent()) {
            String newTimezoneId = TzHelper.getCorrectedTimezoneFromTzParameter(property);
            TzHelper.correctTzParameter(property, newTimezoneId);
        }
    }

    static void correctTzParameterFrom(DateProperty property) {
        if (property.getValue() != null && property.getValue().endsWith("Z")) {
            property.removeAll("TZID");
            return;
        }
        if (property.getParameter("TZID").isPresent()) {
            String newTimezone = TzHelper.getCorrectedTimezoneFromTzParameter(property);
            TzHelper.correctTzParameter(property, newTimezone);
        }
    }

    private static void correctTzParameter(Property property, String newTimezoneId) {
        property.removeAll("TZID");
        if (newTimezoneId != null) {
            property.add(new TzId(newTimezoneId));
        }
    }

    private static String getCorrectedTimezoneFromTzParameter(Property property) {
        Optional tzId = property.getParameter("TZID");
        String tzIdValue = ((TzId)tzId.get()).getValue();
        return TzHelper.getCorrectedTimeZoneIdFrom(tzIdValue);
    }

    static void correctTzValueOf(net.fortuna.ical4j.model.property.TzId tzProperty) {
        String validTimezone = TzHelper.getCorrectedTimeZoneIdFrom(tzProperty.getValue());
        if (validTimezone != null) {
            tzProperty.setValue(validTimezone);
        }
    }

    public static String getCorrectedTimeZoneIdFrom(String value) {
        if (value != null) {
            String string = value = value.contains("\"") ? value.replaceAll("\"", "") : value;
            if (TIMEZONE_REGISTRY.getTimeZone(value) != null) {
                return TIMEZONE_REGISTRY.getTimeZone(value).getID();
            }
            String nameCandidate = MS_TIMEZONE_NAMES.get(value);
            if (nameCandidate != null) {
                return TIMEZONE_REGISTRY.getTimeZone(nameCandidate) != null ? TIMEZONE_REGISTRY.getTimeZone(nameCandidate).getID() : nameCandidate;
            }
            return MS_TIMEZONE_IDS.get(value);
        }
        return null;
    }

    static {
        TimeZoneRegistryFactory timeZoneRegistryFactory = TimeZoneRegistryFactory.getInstance();
        TIMEZONE_REGISTRY = timeZoneRegistryFactory.createRegistry();
        LOG = LoggerFactory.getLogger(TzHelper.class);
        TzHelper.initMsTimezones();
    }
}

