/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.transform.compliance;

import java.time.Instant;
import java.time.Period;
import java.util.Optional;
import net.fortuna.ical4j.model.ChangeManagementPropertyModifiers;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.transform.compliance.Rfc5545ComponentRule;

public class VEventRule
implements Rfc5545ComponentRule<VEvent> {
    @Override
    public VEvent apply(VEvent element) {
        Optional start = element.getDateTimeStart();
        Optional end = element.getDateTimeEnd();
        Optional<Duration> duration = element.getDuration();
        if (end.isPresent() && duration.isPresent() && end.get().getValue() != null) {
            element.remove(duration.get());
        }
        if (start.isPresent() && end.isPresent()) {
            Optional startType = start.get().getParameter("VALUE");
            Optional endType = end.get().getParameter("VALUE");
            if (startType.isPresent() && endType.isPresent() && ((Parameter)startType.get()).getValue().equals(Value.DATE.getValue()) && ((Parameter)endType.get()).getValue().equals(Value.DATE.getValue()) && start.get().getValue().equals(end.get().getValue())) {
                end.get().setDate(end.get().getDate().plus(Period.ofDays(1)));
            }
        }
        if (element.getDateTimeStamp().isEmpty()) {
            element.with(ChangeManagementPropertyModifiers.DTSTAMP, Instant.now());
        }
        return element;
    }

    @Override
    public Class<VEvent> getSupportedType() {
        return VEvent.class;
    }
}

