/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.transform.recurrence;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalField;
import java.util.List;
import net.fortuna.ical4j.model.Month;
import net.fortuna.ical4j.model.TemporalAdapter;
import net.fortuna.ical4j.transform.Transformer;
import net.fortuna.ical4j.transform.recurrence.Frequency;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.TimeZones;

abstract class AbstractDateExpansionRule<T extends Temporal>
implements Transformer<List<T>>,
Serializable {
    private final Frequency frequency;

    AbstractDateExpansionRule(Frequency frequency) {
        this.frequency = frequency;
    }

    Frequency getFrequency() {
        return this.frequency;
    }

    int getSecond(T date) {
        return this.getTemporalField(date, ChronoField.SECOND_OF_MINUTE);
    }

    int getMinute(T date) {
        return this.getTemporalField(date, ChronoField.MINUTE_OF_HOUR);
    }

    int getHour(T date) {
        return this.getTemporalField(date, ChronoField.HOUR_OF_DAY);
    }

    DayOfWeek getDayOfWeek(T date) {
        return DayOfWeek.of(this.getTemporalField(date, ChronoField.DAY_OF_WEEK));
    }

    int getDayOfMonth(T date) {
        return this.getTemporalField(date, ChronoField.DAY_OF_MONTH);
    }

    int getDayOfYear(T date) {
        return this.getTemporalField(date, ChronoField.DAY_OF_YEAR);
    }

    Month getMonth(T date) {
        return Month.valueOf(this.getTemporalField(date, ChronoField.MONTH_OF_YEAR));
    }

    int getYear(T date) {
        return this.getTemporalField(date, ChronoField.YEAR);
    }

    private int getTemporalField(T date, TemporalField field) {
        if (date.isSupported(field)) {
            return date.get(field);
        }
        if (CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
            return TemporalAdapter.toLocalTime(date, TimeZones.getDefault().toZoneId()).get(field);
        }
        throw new IllegalArgumentException("Invalid temporal type for this rule");
    }

    T withTemporalField(T date, TemporalField field, int value) {
        if (date.isSupported(field)) {
            return (T)date.with(field, value);
        }
        throw new IllegalArgumentException("Invalid temporal type for this rule");
    }
}

