/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.transform.recurrence;

import java.time.DayOfWeek;
import java.time.Month;
import java.time.Year;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.WeekDayList;
import net.fortuna.ical4j.transform.recurrence.AbstractDateExpansionRule;
import net.fortuna.ical4j.transform.recurrence.Frequency;

public class ByDayRule<T extends Temporal>
extends AbstractDateExpansionRule<T> {
    private final List<WeekDay> dayList;
    private final WeekFields weekFields;

    public ByDayRule(T seed, Frequency frequency) {
        this(seed, frequency, null);
    }

    public ByDayRule(T seed, Frequency frequency, DayOfWeek firstDayOfWeek) {
        super(frequency);
        this.dayList = new WeekDayList(WeekDay.getWeekDay(this.getDayOfWeek(seed)));
        this.weekFields = firstDayOfWeek != null ? WeekFields.of(firstDayOfWeek, 1) : WeekFields.of(Locale.getDefault());
    }

    public ByDayRule(List<WeekDay> dayList, Frequency frequency) {
        this(dayList, frequency, (DayOfWeek)null);
    }

    public ByDayRule(List<WeekDay> dayList, Frequency frequency, DayOfWeek firstDayOfWeek) {
        super(frequency);
        this.dayList = dayList;
        this.weekFields = firstDayOfWeek != null ? WeekFields.of(firstDayOfWeek, 1) : WeekFields.of(Locale.getDefault());
    }

    @Override
    public List<T> apply(List<T> dates) {
        Function<Temporal, List<Temporal>> transformer;
        if (this.dayList.isEmpty()) {
            return dates;
        }
        ArrayList weekDayDates = new ArrayList();
        switch (this.getFrequency()) {
            case WEEKLY: {
                transformer = new WeeklyExpansionFilter();
                break;
            }
            case MONTHLY: {
                transformer = new MonthlyExpansionFilter();
                break;
            }
            case YEARLY: {
                transformer = new YearlyExpansionFilter();
                break;
            }
            default: {
                transformer = new LimitFilter();
            }
        }
        for (Temporal date : dates) {
            List transformed = transformer.apply(date);
            ArrayList filtered = new ArrayList();
            this.dayList.forEach(day -> filtered.addAll(this.getOffsetDates(transformed.stream().filter(d -> this.getDayOfWeek(d) == WeekDay.getDayOfWeek(day)).collect(Collectors.toList()), day.getOffset())));
            weekDayDates.addAll(filtered);
        }
        return weekDayDates;
    }

    private List<T> getOffsetDates(List<T> dates, int offset) {
        if (offset == 0) {
            return dates;
        }
        ArrayList<Temporal> offsetDates = new ArrayList<Temporal>();
        int size = dates.size();
        if (offset < 0 && offset >= -size) {
            offsetDates.add((Temporal)dates.get(size + offset));
        } else if (offset > 0 && offset <= size) {
            offsetDates.add((Temporal)dates.get(offset - 1));
        }
        return offsetDates;
    }

    private class WeeklyExpansionFilter
    implements Function<T, List<T>> {
        private WeeklyExpansionFilter() {
        }

        @Override
        public List<T> apply(T date) {
            ArrayList retVal = new ArrayList();
            for (int i = 1; i <= 7; ++i) {
                Object candidate = ByDayRule.this.withTemporalField(date, ByDayRule.this.weekFields.dayOfWeek(), i);
                if (!ByDayRule.this.dayList.parallelStream().map(WeekDay::getDayOfWeek).anyMatch(calDay -> ByDayRule.this.getDayOfWeek(candidate) == calDay)) continue;
                retVal.add(candidate);
            }
            return retVal;
        }
    }

    private class MonthlyExpansionFilter
    implements Function<T, List<T>> {
        private MonthlyExpansionFilter() {
        }

        @Override
        public List<T> apply(T date) {
            ArrayList retVal = new ArrayList();
            Month month = Month.of(ByDayRule.this.getMonth(date).getMonthOfYear());
            boolean leapYear = Year.isLeap(ByDayRule.this.getYear(date));
            for (int i = 1; i <= month.length(leapYear); ++i) {
                Object candidate = ByDayRule.this.withTemporalField(date, ChronoField.DAY_OF_MONTH, i);
                if (!ByDayRule.this.dayList.parallelStream().map(WeekDay::getDayOfWeek).anyMatch(calDay -> ByDayRule.this.getDayOfWeek(candidate) == calDay)) continue;
                retVal.add(candidate);
            }
            return retVal;
        }
    }

    private class YearlyExpansionFilter
    implements Function<T, List<T>> {
        private YearlyExpansionFilter() {
        }

        @Override
        public List<T> apply(T date) {
            ArrayList retVal = new ArrayList();
            int year = ByDayRule.this.getYear(date);
            for (int i = 1; i <= Year.of(year).length(); ++i) {
                Object candidate = ByDayRule.this.withTemporalField(date, ChronoField.DAY_OF_YEAR, i);
                if (!ByDayRule.this.dayList.parallelStream().map(WeekDay::getDayOfWeek).anyMatch(calDay -> ByDayRule.this.getDayOfWeek(candidate) == calDay)) continue;
                retVal.add(candidate);
            }
            return retVal;
        }
    }

    private class LimitFilter
    implements Function<T, List<T>> {
        private LimitFilter() {
        }

        @Override
        public List<T> apply(T date) {
            if (ByDayRule.this.dayList.contains(WeekDay.getWeekDay(ByDayRule.this.getDayOfWeek(date)))) {
                return Collections.singletonList(date);
            }
            return Collections.emptyList();
        }
    }
}

