/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.transform.recurrence;

import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fortuna.ical4j.transform.recurrence.AbstractDateExpansionRule;
import net.fortuna.ical4j.transform.recurrence.Frequency;

public class ByHourRule<T extends Temporal>
extends AbstractDateExpansionRule<T> {
    private final List<Integer> hourList;

    public ByHourRule(List<Integer> hourList, Frequency frequency) {
        super(frequency);
        this.hourList = hourList;
    }

    @Override
    public List<T> apply(List<T> dates) {
        if (this.hourList.isEmpty()) {
            return dates;
        }
        ArrayList hourlyDates = new ArrayList();
        for (Temporal date : dates) {
            if (EnumSet.of(Frequency.DAILY, Frequency.WEEKLY, Frequency.MONTHLY, Frequency.YEARLY).contains((Object)this.getFrequency())) {
                hourlyDates.addAll(new ExpansionFilter().apply(date));
                continue;
            }
            Optional<Temporal> limit = new LimitFilter().apply(date);
            limit.ifPresent(hourlyDates::add);
        }
        return hourlyDates;
    }

    private class ExpansionFilter
    implements Function<T, List<T>> {
        private ExpansionFilter() {
        }

        @Override
        public List<T> apply(T date) {
            ArrayList retVal = new ArrayList();
            ByHourRule.this.hourList.forEach(hour -> {
                Temporal candidate = ByHourRule.this.withTemporalField(date, ChronoField.HOUR_OF_DAY, (int)hour);
                retVal.add(candidate);
            });
            return retVal;
        }
    }

    private class LimitFilter
    implements Function<T, Optional<T>> {
        private LimitFilter() {
        }

        @Override
        public Optional<T> apply(T date) {
            if (ByHourRule.this.hourList.contains(ByHourRule.this.getHour(date))) {
                return Optional.of(date);
            }
            return Optional.empty();
        }
    }
}

